/*
 * Decompiled with CFR 0.152.
 */
package fr.CraftMyWebsite.CMWLink.Velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import fr.CraftMyWebsite.CMWLink.Common.Config.ConfigFile;
import fr.CraftMyWebsite.CMWLink.Common.Utils.StartingFrom;
import fr.CraftMyWebsite.CMWLink.Velocity.VL_Commands;
import java.nio.file.Path;
import java.util.logging.Logger;
import lombok.Generated;

@Plugin(id="craftmywebsite-link", name="CraftMyWebsite-Link", version="1.0", url="https://craftmywebsite.fr/", description="CraftMyWebsite-Link a java plugin for MC servers", authors={"CraftMyWebsite"})
public final class VelocityMain {
    private final ProxyServer server;
    private final Path dataDirectory;
    private final Logger logger;
    private ConfigFile configFile;

    @Inject
    public VelocityMain(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    void onProxyInitialization(ProxyInitializeEvent event) {
        this.logger.info("==========================================");
        this.configFile = new ConfigFile(this.server, StartingFrom.VELOCITY, this.dataDirectory.toFile(), this.logger, "1.0");
        this.logger.info("==========================================");
        CommandMeta meta = this.server.getCommandManager().metaBuilder("vcmwl").build();
        this.server.getCommandManager().register(meta, (Command)new VL_Commands(this));
    }

    public void resetConfig() {
        this.configFile = new ConfigFile(this.server, StartingFrom.VELOCITY, this.dataDirectory.toFile(), this.logger, "1.0");
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        if (this.configFile != null) {
            this.configFile.getWebServer().disable();
            this.configFile.getPackages().disablePackages();
        }
    }

    @Generated
    public ConfigFile getConfigFile() {
        return this.configFile;
    }
}

