/*
 * Decompiled with CFR 0.152.
 */
package fr.CraftMyWebsite.CMWLink.Common.WebServer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import express.http.request.Request;
import express.http.response.Response;
import express.utils.Status;
import fr.CraftMyWebsite.CMWLink.Common.Config.JsonBuilder;
import fr.CraftMyWebsite.CMWLink.Common.Packages.CMWLPackage;
import fr.CraftMyWebsite.CMWLink.Common.WebServer.IRoute;
import fr.CraftMyWebsite.CMWLink.Common.WebServer.RouteType;
import java.util.HashMap;
import lombok.Generated;

public abstract class CMWLRoute<PluginType extends CMWLPackage>
implements IRoute {
    private PluginType plugin;
    private String routeName;
    private RouteType routeType;

    public CMWLRoute(PluginType plugin, String routeName, RouteType routeType) {
        this.plugin = plugin;
        this.routeName = routeName;
        this.routeType = routeType;
    }

    @Override
    public void execute(Request req, Response res) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            JsonElement je = JsonParser.parseString((String)this.executeRoute(req.getParams()));
            res.setStatus(Status._200);
            res.send(gson.toJson(je));
        }
        catch (Exception e) {
            e.printStackTrace();
            JsonElement je = JsonParser.parseString((String)new JsonBuilder("CODE", 500).append("MESSAGE", e.getMessage() + ", see console for more informations !").build());
            res.setStatus(Status._500);
            res.send(gson.toJson(je));
        }
    }

    public abstract String executeRoute(HashMap<String, String> var1);

    @Generated
    public PluginType getPlugin() {
        return this.plugin;
    }

    @Override
    @Generated
    public String getRouteName() {
        return this.routeName;
    }

    @Override
    @Generated
    public RouteType getRouteType() {
        return this.routeType;
    }
}

