/*
 * Decompiled with CFR 0.152.
 */
package fr.CraftMyWebsite.CMWLink.Common.Packages;

import com.google.common.base.Preconditions;
import fr.CraftMyWebsite.CMWLink.Common.Packages.CMWLPackage;
import fr.CraftMyWebsite.CMWLink.Common.Packages.CMWLPackageDescription;
import fr.CraftMyWebsite.CMWLink.Common.Packages.PackageClassLoader;
import fr.CraftMyWebsite.CMWLink.Common.Utils.Utils;
import fr.CraftMyWebsite.CMWLink.Common.WebServer.WebServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import lombok.Generated;
import net.md_5.bungee.api.ProxyServer;
import org.bukkit.Server;

public class Packages {
    private Server spServer;
    private ProxyServer bgServer;
    private com.velocitypowered.api.proxy.ProxyServer vlServer;
    private Logger log;
    private WebServer webServer;
    private Utils utils;
    private File defaultPath;
    private File packagesPath;
    private Map<String, CMWLPackageDescription> packagesToLoad;
    private Map<String, PackageClassLoader> loaders;
    private Map<String, Class<?>> classes;
    private HashMap<String, CMWLPackageDescription> packagesCertified;
    private List<CMWLPackage> packagesLoaded;

    public Packages(Server server, Logger log, File defaultPath, WebServer webServer, Utils utils) {
        this.spServer = server;
        this.load(log, defaultPath, webServer, utils);
    }

    public Packages(ProxyServer server, Logger log, File defaultPath, WebServer webServer, Utils utils) {
        this.bgServer = server;
        this.load(log, defaultPath, webServer, utils);
    }

    public Packages(com.velocitypowered.api.proxy.ProxyServer server, Logger log, File defaultPath, WebServer webServer, Utils utils) {
        this.vlServer = server;
        this.load(log, defaultPath, webServer, utils);
    }

    private void load(Logger log, File defaultPath, WebServer webServer, Utils utils) {
        File packagesConfigPath;
        this.log = log;
        this.webServer = webServer;
        this.utils = utils;
        this.defaultPath = defaultPath;
        log.info("Searching packages ...");
        this.packagesPath = new File(String.valueOf(defaultPath) + File.separator + "Packages");
        if (!this.packagesPath.exists()) {
            this.packagesPath.mkdirs();
        }
        if (!(packagesConfigPath = new File(String.valueOf(defaultPath) + File.separator + "PackagesConfig")).exists()) {
            packagesConfigPath.mkdirs();
        }
        this.packagesToLoad = new HashMap<String, CMWLPackageDescription>();
        this.loaders = new LinkedHashMap<String, PackageClassLoader>();
        this.classes = new HashMap();
        this.packagesLoaded = new ArrayList<CMWLPackage>();
        this.packagesCertified = new HashMap();
        this.detectPackages();
        this.certificatePackages();
        this.loadPackages();
    }

    public void disablePackages() {
        for (CMWLPackage miniPlugin : this.packagesLoaded) {
            miniPlugin.onDisable();
        }
    }

    private void detectPackages() {
        for (File file : this.packagesPath.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            try (JarFile jar = new JarFile(file);){
                JarEntry pdf = jar.getJarEntry("package.yml");
                Preconditions.checkNotNull((Object)pdf, (Object)"Package must have a Package.yml");
                try (InputStream in = jar.getInputStream(pdf);){
                    CMWLPackageDescription desc = new CMWLPackageDescription(in);
                    Preconditions.checkNotNull((Object)desc.getName(), (String)"Package from %s has no name", (Object)file);
                    Preconditions.checkNotNull((Object)desc.getRoute_prefix(), (String)"Package from %s has no route prefix", (Object)file);
                    Preconditions.checkNotNull((Object)desc.getVersion(), (String)"Package from %s has no version", (Object)file);
                    Preconditions.checkNotNull((Object)desc.getAuthor(), (String)"Package from %s has no author", (Object)file);
                    desc.setFile(file);
                    this.packagesToLoad.put(desc.getName(), desc);
                }
            }
            catch (Exception ex) {
                this.log.warning("Could not load package from file " + String.valueOf(file));
                ex.printStackTrace();
            }
        }
        this.log.info("Packages found: " + this.packagesToLoad.size());
    }

    private void certificatePackages() {
        this.log.info("Waiting for packages certification...");
        ExecutorService executor = Executors.newFixedThreadPool(5);
        for (final CMWLPackageDescription packageDesc : this.packagesToLoad.values()) {
            Runnable worker = new Runnable(){

                @Override
                public void run() {
                    String localMd5 = Packages.this.getMd5(packageDesc.getFile().getAbsoluteFile());
                    if (Packages.this.checkMd5CMW(localMd5)) {
                        Packages.this.log.info("Checked " + packageDesc.getName() + " is CERTIFIED by CMW.");
                        Packages.this.packagesCertified.put(packageDesc.getName(), packageDesc);
                    } else if (!Packages.this.webServer.getConfig().getSettings().isLoadUncertifiedPackages()) {
                        Packages.this.log.severe(packageDesc.getName() + " is not certified by CMW, it will not be loaded.");
                    } else {
                        Packages.this.log.warning(packageDesc.getName() + " is not certified by CMW, it will loaded because loadUncertifiedPackages is enabled in settings.json.");
                    }
                }
            };
            try {
                executor.execute(worker);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        if (!this.webServer.getConfig().getSettings().isLoadUncertifiedPackages()) {
            this.log.info("If you want to load UNCERTIFIED packages, enable loadUncertifiedPackages in settings.json");
        }
    }

    private boolean checkMd5CMW(String md5) {
        return true;
    }

    private String getMd5(File file) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            FileInputStream fis = new FileInputStream(file);
            byte[] byteArray = new byte[1024];
            int bytesCount = 0;
            while ((bytesCount = fis.read(byteArray)) != -1) {
                digest.update(byteArray, 0, bytesCount);
            }
            fis.close();
            byte[] bytes = digest.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString().toUpperCase();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.log.severe("Cannot read MD5 of file " + file.getAbsolutePath() + ", error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void loadPackages() {
        HashMap<CMWLPackageDescription, Boolean> pluginStatuses = new HashMap<CMWLPackageDescription, Boolean>();
        for (Map.Entry<String, CMWLPackageDescription> entry : this.packagesToLoad.entrySet()) {
            CMWLPackageDescription plugin = entry.getValue();
            if (this.enablePackage(pluginStatuses, new Stack<CMWLPackageDescription>(), plugin)) continue;
            this.log.warning("Failed to enable " + entry.getKey());
        }
    }

    private boolean enablePackage(Map<CMWLPackageDescription, Boolean> pluginStatuses, Stack<CMWLPackageDescription> dependStack, CMWLPackageDescription plugin) {
        if (pluginStatuses.containsKey(plugin)) {
            return pluginStatuses.get(plugin);
        }
        HashSet<String> dependencies = new HashSet<String>();
        dependencies.addAll(plugin.getDepends());
        boolean status = true;
        for (String dependName : dependencies) {
            Boolean dependStatus;
            CMWLPackageDescription depend = this.packagesToLoad.get(dependName);
            Boolean bl = dependStatus = depend != null ? pluginStatuses.get(depend) : Boolean.FALSE;
            if (dependStatus == null) {
                if (dependStack.contains(depend)) {
                    StringBuilder dependencyGraph = new StringBuilder();
                    for (CMWLPackageDescription element : dependStack) {
                        dependencyGraph.append(element.getName()).append(" -> ");
                    }
                    dependencyGraph.append(plugin.getName()).append(" -> ").append(dependName);
                    this.log.warning("Circular dependency detected: " + String.valueOf(dependencyGraph));
                    status = false;
                } else {
                    dependStack.push(plugin);
                    dependStatus = this.enablePackage(pluginStatuses, dependStack, depend);
                    dependStack.pop();
                }
            }
            if (dependStatus == Boolean.FALSE && plugin.getDepends().contains(dependName)) {
                this.log.warning(String.valueOf(new Object[]{String.valueOf(dependName)}) + " (required by {1}) is unavailable " + plugin.getName());
                status = false;
            }
            if (status) continue;
            break;
        }
        if (!this.webServer.getConfig().getSettings().isLoadUncertifiedPackages()) {
            if (this.packagesCertified.containsValue(plugin)) {
                this.loadPlugin(status, plugin);
            }
        } else {
            this.loadPlugin(status, plugin);
        }
        pluginStatuses.put(plugin, status);
        return status;
    }

    private void loadPlugin(boolean status, CMWLPackageDescription plugin) {
        if (status) {
            try {
                PackageClassLoader loader = null;
                Class<?> main = null;
                switch (this.webServer.getConfig().getStartingFrom()) {
                    case BUNGEECORD: {
                        Preconditions.checkNotNull((Object)plugin.getBg_main(), (String)"Package from %s has no sp_main main class, maybe not compatible with BungeeCord ?", (Object)plugin.getFile());
                        loader = new PackageClassLoader(this.getClass().getClassLoader(), plugin.getBg_main(), plugin.getFile().toURI().toURL(), this);
                        main = loader.loadClass(plugin.getBg_main());
                        break;
                    }
                    case SPIGOT: {
                        Preconditions.checkNotNull((Object)plugin.getSp_main(), (String)"Package from %s has no bg_main main class, maybe not compatible with Spigot/Paper ?", (Object)plugin.getFile());
                        loader = new PackageClassLoader(this.getClass().getClassLoader(), plugin.getSp_main(), plugin.getFile().toURI().toURL(), this);
                        main = loader.loadClass(plugin.getSp_main());
                        break;
                    }
                    case VELOCITY: {
                        Preconditions.checkNotNull((Object)plugin.getVl_main(), (String)"Package from %s has no vl_main main class, maybe not compatible with Velocity ?", (Object)plugin.getFile());
                        loader = new PackageClassLoader(this.getClass().getClassLoader(), plugin.getVl_main(), plugin.getFile().toURI().toURL(), this);
                        main = loader.loadClass(plugin.getVl_main());
                    }
                }
                this.loaders.put(plugin.getName(), loader);
                CMWLPackage clazz = (CMWLPackage)main.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                switch (this.webServer.getConfig().getStartingFrom()) {
                    case BUNGEECORD: {
                        clazz.init(this.bgServer, this.webServer.getConfig().getStartingFrom(), plugin.getName(), plugin.getRoute_prefix(), plugin.getVersion(), this.defaultPath, this.log, this.webServer, this.utils);
                        break;
                    }
                    case SPIGOT: {
                        clazz.init(this.spServer, this.webServer.getConfig().getStartingFrom(), plugin.getName(), plugin.getRoute_prefix(), plugin.getVersion(), this.defaultPath, this.log, this.webServer, this.utils);
                        break;
                    }
                    case VELOCITY: {
                        clazz.init(this.vlServer, this.webServer.getConfig().getStartingFrom(), plugin.getName(), plugin.getRoute_prefix(), plugin.getVersion(), this.defaultPath, this.log, this.webServer, this.utils);
                    }
                }
                this.log.info("Loaded " + (this.packagesCertified.containsValue(plugin) ? "CERTIFIED" : "UNCERTIFIED") + " package " + plugin.getName() + " version " + plugin.getVersion() + " by " + plugin.getAuthor());
                this.packagesLoaded.add(clazz);
            }
            catch (Throwable t) {
                this.log.severe("Error enabling package " + plugin.getName() + ": " + t.getMessage());
                t.printStackTrace();
            }
        }
    }

    public Class<?> getClassByName(String name) {
        Class<?> cachedClass = this.classes.get(name);
        if (cachedClass != null) {
            return cachedClass;
        }
        for (String current : this.loaders.keySet()) {
            PackageClassLoader loader = this.loaders.get(current);
            try {
                cachedClass = loader.findClass(name, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (cachedClass == null) continue;
            return cachedClass;
        }
        return null;
    }

    @Generated
    public Server getSpServer() {
        return this.spServer;
    }

    @Generated
    public ProxyServer getBgServer() {
        return this.bgServer;
    }

    @Generated
    public com.velocitypowered.api.proxy.ProxyServer getVlServer() {
        return this.vlServer;
    }

    @Generated
    public HashMap<String, CMWLPackageDescription> getPackagesCertified() {
        return this.packagesCertified;
    }

    @Generated
    public List<CMWLPackage> getPackagesLoaded() {
        return this.packagesLoaded;
    }
}

