/*
 * Decompiled with CFR 0.152.
 */
package fr.CraftMyWebsite.CMWLink.Common.Packages;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Node;

public class CMWLPackageDescription {
    private static final ThreadLocal<Yaml> YAML = new ThreadLocal<Yaml>(){

        @Override
        @NotNull
        protected Yaml initialValue() {
            return new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()){
                {
                    this.yamlConstructors.put(null, new AbstractConstruct(){

                        @NotNull
                        public Object construct(@NotNull Node node) {
                            return node.toString();
                        }
                    });
                }
            });
        }
    };
    private String name;
    private String route_prefix;
    private String sp_main;
    private String bg_main;
    private String vl_main;
    private String version;
    private String author;
    @NotNull
    private List<String> depends = new ArrayList<String>();
    private File file = null;

    public CMWLPackageDescription(@NotNull InputStream stream) {
        this.loadMap(this.asMap(YAML.get().load(stream)));
    }

    private void loadMap(@NotNull Map<?, ?> map) {
        this.name = map.get("name").toString();
        this.route_prefix = map.get("route_prefix").toString();
        this.version = map.get("version").toString();
        this.author = map.get("author").toString();
        if (map.get("sp_main") != null) {
            this.sp_main = map.get("sp_main").toString();
        }
        if (map.get("bg_main") != null) {
            this.bg_main = map.get("bg_main").toString();
        }
        if (map.get("vl_main") != null) {
            this.vl_main = map.get("vl_main").toString();
        }
        this.depends = CMWLPackageDescription.makePluginNameList(map, "depends");
    }

    @NotNull
    private static List<String> makePluginNameList(@NotNull Map<?, ?> map, @NotNull String key) {
        Object value = map.get(key);
        if (value == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            for (Object entry : (Iterable)value) {
                builder.add((Object)entry.toString().replace(' ', '_'));
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return builder.build();
    }

    @NotNull
    private Map<?, ?> asMap(@NotNull Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        return Map.of();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getRoute_prefix() {
        return this.route_prefix;
    }

    @Generated
    public String getSp_main() {
        return this.sp_main;
    }

    @Generated
    public String getBg_main() {
        return this.bg_main;
    }

    @Generated
    public String getVl_main() {
        return this.vl_main;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @NotNull
    @Generated
    public List<String> getDepends() {
        return this.depends;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRoute_prefix(String route_prefix) {
        this.route_prefix = route_prefix;
    }

    @Generated
    public void setSp_main(String sp_main) {
        this.sp_main = sp_main;
    }

    @Generated
    public void setBg_main(String bg_main) {
        this.bg_main = bg_main;
    }

    @Generated
    public void setVl_main(String vl_main) {
        this.vl_main = vl_main;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setAuthor(String author) {
        this.author = author;
    }

    @Generated
    public void setDepends(@NotNull List<String> depends) {
        if (depends == null) {
            throw new NullPointerException("depends is marked non-null but is null");
        }
        this.depends = depends;
    }

    @Generated
    public void setFile(File file) {
        this.file = file;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CMWLPackageDescription)) {
            return false;
        }
        CMWLPackageDescription other = (CMWLPackageDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$route_prefix = this.getRoute_prefix();
        String other$route_prefix = other.getRoute_prefix();
        if (this$route_prefix == null ? other$route_prefix != null : !this$route_prefix.equals(other$route_prefix)) {
            return false;
        }
        String this$sp_main = this.getSp_main();
        String other$sp_main = other.getSp_main();
        if (this$sp_main == null ? other$sp_main != null : !this$sp_main.equals(other$sp_main)) {
            return false;
        }
        String this$bg_main = this.getBg_main();
        String other$bg_main = other.getBg_main();
        if (this$bg_main == null ? other$bg_main != null : !this$bg_main.equals(other$bg_main)) {
            return false;
        }
        String this$vl_main = this.getVl_main();
        String other$vl_main = other.getVl_main();
        if (this$vl_main == null ? other$vl_main != null : !this$vl_main.equals(other$vl_main)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        List<String> this$depends = this.getDepends();
        List<String> other$depends = other.getDepends();
        if (this$depends == null ? other$depends != null : !((Object)this$depends).equals(other$depends)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CMWLPackageDescription;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $route_prefix = this.getRoute_prefix();
        result = result * 59 + ($route_prefix == null ? 43 : $route_prefix.hashCode());
        String $sp_main = this.getSp_main();
        result = result * 59 + ($sp_main == null ? 43 : $sp_main.hashCode());
        String $bg_main = this.getBg_main();
        result = result * 59 + ($bg_main == null ? 43 : $bg_main.hashCode());
        String $vl_main = this.getVl_main();
        result = result * 59 + ($vl_main == null ? 43 : $vl_main.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        List<String> $depends = this.getDepends();
        result = result * 59 + ($depends == null ? 43 : ((Object)$depends).hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CMWLPackageDescription(name=" + this.getName() + ", route_prefix=" + this.getRoute_prefix() + ", sp_main=" + this.getSp_main() + ", bg_main=" + this.getBg_main() + ", vl_main=" + this.getVl_main() + ", version=" + this.getVersion() + ", author=" + this.getAuthor() + ", depends=" + String.valueOf(this.getDepends()) + ", file=" + String.valueOf(this.getFile()) + ")";
    }

    @Generated
    public CMWLPackageDescription() {
    }

    @Generated
    public CMWLPackageDescription(String name, String route_prefix, String sp_main, String bg_main, String vl_main, String version, String author, @NotNull List<String> depends, File file) {
        if (depends == null) {
            throw new NullPointerException("depends is marked non-null but is null");
        }
        this.name = name;
        this.route_prefix = route_prefix;
        this.sp_main = sp_main;
        this.bg_main = bg_main;
        this.vl_main = vl_main;
        this.version = version;
        this.author = author;
        this.depends = depends;
        this.file = file;
    }
}

