/*
 * Decompiled with CFR 0.152.
 */
package fr.CraftMyWebsite.CMWLink.Common.Packages;

import fr.CraftMyWebsite.CMWLink.Common.Utils.StartingFrom;
import fr.CraftMyWebsite.CMWLink.Common.Utils.Utils;
import fr.CraftMyWebsite.CMWLink.Common.WebServer.IRoute;
import fr.CraftMyWebsite.CMWLink.Common.WebServer.WebServer;
import java.io.File;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import net.md_5.bungee.api.ProxyServer;
import org.bukkit.Server;

public abstract class CMWLPackage {
    private Server spServer;
    private ProxyServer bgServer;
    private com.velocitypowered.api.proxy.ProxyServer vlServer;
    private boolean alreadyInit = false;
    private StartingFrom startingFrom;
    private String packageName;
    private String routePrefix;
    private String version;
    private File mainFolder;
    private Logger log;
    private WebServer webServer;
    private Utils utils;
    private boolean isUseProxy;
    private Object packageConfig;

    public void init(Server server, StartingFrom startingFrom, String packageName, String routePrefix, String version, File mainFolder, Logger log, WebServer webServer, Utils utils) {
        if (!this.alreadyInit) {
            this.spServer = server;
            this.startingFrom = startingFrom;
            this.packageName = packageName;
            this.routePrefix = routePrefix;
            this.version = version;
            this.mainFolder = new File(String.valueOf(mainFolder) + File.separator + "PackagesConfig" + File.separator + packageName);
            this.log = log;
            this.webServer = webServer;
            this.utils = utils;
            this.isUseProxy = webServer.getConfig().getSettings().isUseProxy();
            this.onEnable();
            this.alreadyInit = true;
        } else {
            this.log(Level.SEVERE, "Package already initiated !");
        }
    }

    public void init(ProxyServer server, StartingFrom startingFrom, String packageName, String routePrefix, String version, File mainFolder, Logger log, WebServer webServer, Utils utils) {
        if (!this.alreadyInit) {
            this.bgServer = server;
            this.startingFrom = startingFrom;
            this.packageName = packageName;
            this.routePrefix = routePrefix;
            this.version = version;
            this.mainFolder = new File(String.valueOf(mainFolder) + File.separator + "PackagesConfig" + File.separator + packageName);
            this.log = log;
            this.webServer = webServer;
            this.utils = utils;
            this.isUseProxy = webServer.getConfig().getSettings().isUseProxy();
            this.onEnable();
            this.alreadyInit = true;
        } else {
            this.log(Level.SEVERE, "Package already initiated !");
        }
    }

    public void init(com.velocitypowered.api.proxy.ProxyServer server, StartingFrom startingFrom, String packageName, String routePrefix, String version, File mainFolder, Logger log, WebServer webServer, Utils utils) {
        if (!this.alreadyInit) {
            this.vlServer = server;
            this.startingFrom = startingFrom;
            this.packageName = packageName;
            this.routePrefix = routePrefix;
            this.version = version;
            this.mainFolder = new File(String.valueOf(mainFolder) + File.separator + "PackagesConfig" + File.separator + packageName);
            this.log = log;
            this.webServer = webServer;
            this.utils = utils;
            this.isUseProxy = webServer.getConfig().getSettings().isUseProxy();
            this.onEnable();
            this.alreadyInit = true;
        } else {
            this.log(Level.SEVERE, "Package already initiated !");
        }
    }

    public final void onEnable() {
        long epoch = System.currentTimeMillis();
        this.log(Level.INFO, "Loading...");
        if (!this.mainFolder.exists()) {
            this.mainFolder.mkdirs();
        }
        this.enable();
        this.registerRoutes();
        this.log(Level.INFO, "Enabled in " + this.convertString(System.currentTimeMillis() - epoch, 1, TimeUnit.MILLISECONDS) + ".");
    }

    public final void onDisable() {
        this.disable();
        this.log(Level.INFO, "Disabled.");
    }

    public abstract void enable();

    public abstract void disable();

    public abstract void registerRoutes();

    public final void addRoute(IRoute route) {
        this.webServer.addRoute(this, route);
    }

    public final void removeRoute(IRoute route) {
        this.webServer.removeRoute(this, route);
    }

    public void log(Level level, String message) {
        this.log.log(level, "{" + this.packageName + ", Version: " + this.version + "}==> " + message);
    }

    public String convertString(long time, int trim, TimeUnit type) {
        if (time == -1L) {
            return "Permanent";
        }
        if (type == TimeUnit.FIT) {
            type = time < 60000L ? TimeUnit.SECONDS : (time < 3600000L ? TimeUnit.MINUTES : (time < 86400000L ? TimeUnit.HOURS : TimeUnit.DAYS));
        }
        if (type == TimeUnit.DAYS) {
            return this.trim(trim, (double)time / 8.64E7) + " Jours";
        }
        if (type == TimeUnit.HOURS) {
            return this.trim(trim, (double)time / 3600000.0) + " Heures";
        }
        if (type == TimeUnit.MINUTES) {
            return this.trim(trim, (double)time / 60000.0) + " Minutes";
        }
        if (type == TimeUnit.SECONDS) {
            return this.trim(trim, (double)time / 1000.0) + " Secondes";
        }
        return this.trim(trim, time) + " Milliseconds";
    }

    private double trim(int degree, double d) {
        Object format = "#.#";
        for (int i = 1; i < degree; ++i) {
            format = (String)format + "#";
        }
        DecimalFormat twoDForm = new DecimalFormat((String)format);
        return Double.valueOf(twoDForm.format(d));
    }

    @Generated
    public Server getSpServer() {
        return this.spServer;
    }

    @Generated
    public ProxyServer getBgServer() {
        return this.bgServer;
    }

    @Generated
    public com.velocitypowered.api.proxy.ProxyServer getVlServer() {
        return this.vlServer;
    }

    @Generated
    public StartingFrom getStartingFrom() {
        return this.startingFrom;
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public String getRoutePrefix() {
        return this.routePrefix;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public File getMainFolder() {
        return this.mainFolder;
    }

    @Generated
    public Utils getUtils() {
        return this.utils;
    }

    @Generated
    public boolean isUseProxy() {
        return this.isUseProxy;
    }

    @Generated
    public Object getPackageConfig() {
        return this.packageConfig;
    }

    public static enum TimeUnit {
        FIT,
        DAYS,
        HOURS,
        MINUTES,
        SECONDS,
        MILLISECONDS;

    }
}

