/*
 * Decompiled with CFR 0.152.
 */
package fr.CraftMyWebsite.CMWLink.Common.Config;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.CraftMyWebsite.CMWLink.Common.Config.IConfigFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Persist {
    private IConfigFile configFile;
    private Gson gson;
    private Map<String, Lock> locks;

    public Persist(IConfigFile configFile) {
        configFile.getFilePath().mkdirs();
        this.configFile = configFile;
        this.gson = this.buildGson().create();
        this.locks = new HashMap<String, Lock>();
    }

    public String getName(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    public String getName(Object o) {
        return this.getName(o.getClass());
    }

    private GsonBuilder buildGson() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().excludeFieldsWithModifiers(new int[]{128, 64});
    }

    public File getFile(String name) {
        return new File(String.valueOf(this.configFile.getFilePath()) + File.separator + name + ".json");
    }

    public File getFile(Class<?> clazz) {
        return this.getFile(this.getName(clazz));
    }

    public File getFile(Object obj) {
        return this.getFile(this.getName(obj));
    }

    public void save(Object instance) {
        this.save(instance, this.getFile(instance));
    }

    public void save(Object instance, File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.configFile.getLog().severe("Failed to save file: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.writeCatch(file, this.gson.toJson(instance));
    }

    public <T> T load(Class<T> clazz) {
        return this.load(clazz, this.getFile(clazz));
    }

    public <T> T load(Class<T> clazz, File file) {
        String content = this.readCatch(file);
        if (content == null) {
            return null;
        }
        try {
            return (T)this.gson.fromJson(content, clazz);
        }
        catch (Exception ex) {
            this.configFile.getLog().severe("Failed to parse " + file.toString() + ": " + ex.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCatch(File file, String content) {
        Lock lock;
        String name = file.getName();
        if (this.locks.containsKey(name)) {
            lock = this.locks.get(name);
        } else {
            ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
            lock = rwl.writeLock();
            this.locks.put(name, lock);
        }
        lock.lock();
        try {
            file.createNewFile();
            Files.write((byte[])content.getBytes(), (File)file);
        }
        catch (IOException e) {
            this.configFile.getLog().severe("Failed to write data to file: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    public String readCatch(File file) {
        try {
            return this.read(file);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String read(File file) throws IOException {
        return this.utf8(this.readBytes(file));
    }

    public byte[] readBytes(File file) throws IOException {
        int length = (int)file.length();
        byte[] output = new byte[length];
        FileInputStream in = new FileInputStream(file);
        for (int offset = 0; offset < length; offset += ((InputStream)in).read(output, offset, length - offset)) {
        }
        ((InputStream)in).close();
        return output;
    }

    public String utf8(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

