/*
 * Decompiled with CFR 0.152.
 */
package fr.CraftMyWebsite.CMWLink.Common.Config;

import fr.CraftMyWebsite.CMWLink.Common.Config.IConfigFile;
import fr.CraftMyWebsite.CMWLink.Common.Config.Persist;
import fr.CraftMyWebsite.CMWLink.Common.Packages.Packages;
import fr.CraftMyWebsite.CMWLink.Common.Utils.StartingFrom;
import fr.CraftMyWebsite.CMWLink.Common.Utils.Utils;
import fr.CraftMyWebsite.CMWLink.Common.WebServer.WebServer;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import lombok.Generated;
import net.md_5.bungee.api.ProxyServer;
import org.bukkit.Server;

public class ConfigFile
extends IConfigFile {
    private Server spServer;
    private ProxyServer bgServer;
    private com.velocitypowered.api.proxy.ProxyServer vlServer;
    private StartingFrom startingFrom;
    private File filePath;
    private Logger log;
    private String version;
    private Settings settings;
    private Utils utils;
    private Packages packages;
    private WebServer webServer;
    private Persist persist;

    public ConfigFile(Server server, StartingFrom startingFrom, File filePath, Logger log, String version) {
        super(filePath, log);
        this.spServer = server;
        this.load(startingFrom, filePath, log, version, server.getPort());
    }

    public ConfigFile(ProxyServer server, StartingFrom startingFrom, File filePath, Logger log, String version) {
        super(filePath, log);
        this.bgServer = server;
        this.load(startingFrom, filePath, log, version, 0);
    }

    public ConfigFile(com.velocitypowered.api.proxy.ProxyServer server, StartingFrom startingFrom, File filePath, Logger log, String version) {
        super(filePath, log);
        this.vlServer = server;
        this.load(startingFrom, filePath, log, version, 0);
    }

    public void load(StartingFrom startingFrom, File filePath, Logger log, String version, int port) {
        this.startingFrom = startingFrom;
        this.filePath = filePath;
        this.log = log;
        this.version = version;
        this.utils = new Utils(log, startingFrom);
        this.persist = new Persist(this);
        if (this.utils.init(true)) {
            log.info("Loading configuration...");
            this.settings = this.persist.getFile(Settings.class).exists() ? this.persist.load(Settings.class) : new Settings();
            this.saveSettings();
            log.info("Configuration loaded successfully !");
            if (this.settings.isBindToDefaultPort()) {
                log.info("- WebServer binded to default server port");
            } else {
                log.info("- Port: " + this.settings.getPort());
            }
            if (this.settings.isUseCustomServerAddress()) {
                log.info("- Use custom address: " + this.settings.getCustomServerAddress());
            }
            log.info("- Log Requests: " + this.settings.isLogRequests());
            log.info("- Using proxy: " + this.settings.isUseProxy());
            log.info("- Load Uncertified packages: " + this.settings.isLoadUncertifiedPackages());
            if (this.settings.isEnableWhitelistedIps()) {
                log.info("- Whitelisted IP: " + String.valueOf(this.settings.getWhitelistedIps()));
            }
            this.webServer = new WebServer(this);
            switch (this.startingFrom) {
                case BUNGEECORD: {
                    this.packages = new Packages(this.bgServer, log, filePath, this.webServer, this.utils);
                    if (this.settings.useProxy) {
                        this.startWebServerBungeecord(port);
                        break;
                    }
                    log.severe("UseProxy on this BungeeCord Proxy is not set to true !");
                    log.severe("CMW-Link will be useless");
                    break;
                }
                case SPIGOT: {
                    this.packages = new Packages(this.spServer, log, filePath, this.webServer, this.utils);
                    if (this.settings.isUseProxy()) {
                        log.info("Waiting requests from the proxy");
                        break;
                    }
                    this.startWebServerSpigot(port);
                    break;
                }
                case VELOCITY: {
                    this.packages = new Packages(this.vlServer, log, filePath, this.webServer, this.utils);
                    if (this.settings.useProxy) {
                        this.startWebServerVelocity(port);
                        break;
                    }
                    log.severe("UseProxy on this Velocity Proxy is not set to true !");
                    log.severe("CMW-Link will be useless");
                }
            }
        }
    }

    public void saveSettings() {
        if (this.settings != null) {
            this.persist.save(this.settings);
        }
    }

    private void startWebServerBungeecord(int port) {
        this.webServer.createRoutes();
        this.webServer.listenPort();
        this.webServer.startWebServer(port);
    }

    private void startWebServerSpigot(int port) {
        this.webServer.createRoutes();
        this.webServer.listenPort();
        this.webServer.startWebServer(port);
    }

    private void startWebServerVelocity(int port) {
        this.webServer.createRoutes();
        this.webServer.listenPort();
        this.webServer.startWebServer(port);
    }

    @Generated
    public Server getSpServer() {
        return this.spServer;
    }

    @Generated
    public ProxyServer getBgServer() {
        return this.bgServer;
    }

    @Generated
    public com.velocitypowered.api.proxy.ProxyServer getVlServer() {
        return this.vlServer;
    }

    @Generated
    public StartingFrom getStartingFrom() {
        return this.startingFrom;
    }

    @Override
    @Generated
    public File getFilePath() {
        return this.filePath;
    }

    @Override
    @Generated
    public Logger getLog() {
        return this.log;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public Utils getUtils() {
        return this.utils;
    }

    @Generated
    public Packages getPackages() {
        return this.packages;
    }

    @Generated
    public WebServer getWebServer() {
        return this.webServer;
    }

    public class Settings {
        private int port = 24102;
        private boolean bindToDefaultPort = false;
        private boolean useCustomServerAddress = false;
        private String customServerAddress = "123.123.123.123";
        private boolean loadUncertifiedPackages = false;
        private boolean logRequests = true;
        private boolean useProxy = false;
        private boolean enableWhitelistedIps = false;
        private List<String> whitelistedIps = Arrays.asList("127.0.0.1");
        private String token = "TO_GENERATE";
        private String domain = "TO_GENERATE";

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public boolean isBindToDefaultPort() {
            return this.bindToDefaultPort;
        }

        @Generated
        public boolean isUseCustomServerAddress() {
            return this.useCustomServerAddress;
        }

        @Generated
        public String getCustomServerAddress() {
            return this.customServerAddress;
        }

        @Generated
        public boolean isLoadUncertifiedPackages() {
            return this.loadUncertifiedPackages;
        }

        @Generated
        public boolean isLogRequests() {
            return this.logRequests;
        }

        @Generated
        public boolean isUseProxy() {
            return this.useProxy;
        }

        @Generated
        public boolean isEnableWhitelistedIps() {
            return this.enableWhitelistedIps;
        }

        @Generated
        public List<String> getWhitelistedIps() {
            return this.whitelistedIps;
        }

        @Generated
        public String getToken() {
            return this.token;
        }

        @Generated
        public void setToken(String token) {
            this.token = token;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public void setDomain(String domain) {
            this.domain = domain;
        }
    }
}

