/*
 * Decompiled with CFR 0.152.
 */
package express.http.request;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsExchange;
import express.Express;
import express.filter.Filter;
import express.http.Cookie;
import express.http.request.Authorization;
import express.http.request.RequestUtils;
import express.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class Request {
    private final Express express;
    private final String protocol;
    private final URI uri;
    private final InputStream body;
    private final Headers headers;
    private final boolean secure;
    private final String contentType;
    private final long contentLength;
    private final String method;
    private final List<Authorization> auth;
    private final InetSocketAddress inet;
    private final HashMap<String, Object> middleware = new HashMap();
    private final HashMap<String, Cookie> cookies;
    private final HashMap<String, String> queries;
    private final HashMap<String, String> formQueries;
    private HashMap<String, String> params = new HashMap();
    private String context;

    public Request(HttpExchange exchange, Express express) {
        this.express = express;
        this.method = exchange.getRequestMethod();
        this.uri = exchange.getRequestURI();
        this.headers = exchange.getRequestHeaders();
        this.body = exchange.getRequestBody();
        this.inet = exchange.getRemoteAddress();
        this.protocol = exchange.getProtocol();
        this.secure = exchange instanceof HttpsExchange;
        String contentLength = this.headers.get("Content-Length") != null ? (String)this.headers.get("Content-Length").get(0) : null;
        this.contentLength = contentLength != null ? Long.parseLong(contentLength) : -1L;
        this.contentType = this.headers.get("Content-Type") == null ? "" : (String)this.headers.get("Content-Type").get(0);
        this.auth = Authorization.get(this);
        this.formQueries = this.contentType.startsWith("application/x-www-form-urlencoded") ? RequestUtils.parseRawQuery(Utils.streamToString(this.body)) : new HashMap();
        this.queries = RequestUtils.parseRawQuery(exchange.getRequestURI().getRawQuery());
        this.cookies = RequestUtils.parseCookies(this.headers);
    }

    public InputStream getBody() {
        return this.body;
    }

    public void pipe(OutputStream os, int bufferSize) throws IOException {
        int n;
        byte[] buffer = new byte[bufferSize];
        while ((n = this.body.read(buffer)) != -1) {
            os.write(buffer, 0, n);
        }
        os.close();
    }

    public void pipe(Path f, int bufferSize) throws IOException {
        if (Files.exists(f, new LinkOption[0])) {
            return;
        }
        Files.createFile(f, new FileAttribute[0]);
        this.pipe(Files.newOutputStream(f, new OpenOption[0]), bufferSize);
    }

    public Cookie getCookie(String name) {
        return this.cookies.get(name);
    }

    public HashMap<String, Cookie> getCookies() {
        return this.cookies;
    }

    public void addMiddlewareContent(Filter middleware, Object middlewareData) {
        this.middleware.put(middleware.getName(), middlewareData);
    }

    public Object getMiddlewareContent(String name) {
        return this.middleware.get(name);
    }

    public String getUserAgent() {
        return (String)this.headers.get("User-agent").get(0);
    }

    public String getHost() {
        return (String)this.headers.get("Host").get(0);
    }

    public InetAddress getAddress() {
        return this.inet.getAddress();
    }

    public String getIp() {
        return this.inet.getAddress().getHostAddress();
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public URI getURI() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isFresh() {
        if (this.headers.containsKey("cache-control") && this.headers.get("cache-control").get(0) != null && ((String)this.headers.get("cache-control").get(0)).equals("no-cache")) {
            return true;
        }
        if (this.headers.containsKey("if-none-match") && this.headers.get("if-none-match").get(0) != null && ((String)this.headers.get("if-none-match").get(0)).equals("*")) {
            return true;
        }
        if (this.headers.containsKey("if-modified-since") && this.headers.containsKey("last-modified") && this.headers.containsKey("modified")) {
            Object lmlist = this.headers.get("last-modified");
            Object mlist = this.headers.get("modified");
            if (lmlist.isEmpty() || mlist.isEmpty()) {
                return false;
            }
            String lm = (String)lmlist.get(0);
            String m = (String)mlist.get(0);
            if (lm != null && m != null) {
                try {
                    Instant lmi = Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(lm));
                    Instant mi = Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(m));
                    if (lmi.isBefore(mi) || lmi.equals(mi)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean isStale() {
        return !this.isFresh();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isXHR() {
        return this.headers.containsKey("X-Requested-With") && !this.headers.get("X-Requested-With").isEmpty() && ((String)this.headers.get("X-Requested-With").get(0)).equals("XMLHttpRequest");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public List<Authorization> getAuthorization() {
        return Collections.unmodifiableList(this.auth);
    }

    public boolean hasAuthorization() {
        return !this.auth.isEmpty();
    }

    public String getFormQuery(String name) {
        return this.formQueries.get(name);
    }

    public String getParam(String param) {
        return this.params.get(param);
    }

    public String getQuery(String name) {
        return this.queries.get(name);
    }

    public HashMap<String, String> getFormQuerys() {
        return this.formQueries;
    }

    public HashMap<String, String> getParams() {
        return this.params;
    }

    public void setParams(HashMap<String, String> params) {
        this.params = params;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public HashMap<String, String> getQuerys() {
        return this.queries;
    }

    public List<String> getHeader(String header) {
        return Optional.ofNullable(this.headers.get(header)).orElse(Collections.emptyList());
    }

    public Express getApp() {
        return this.express;
    }

    @Generated
    public Headers getHeaders() {
        return this.headers;
    }
}

