/*
 * Decompiled with CFR 0.152.
 */
package fr.CraftMyWebsite.CMWLink.Votes.Common;

import fr.CraftMyWebsite.CMWLink.Common.Packages.CMWLPackage;
import fr.CraftMyWebsite.CMWLink.Votes.Common.Config;
import fr.CraftMyWebsite.CMWLink.Votes.Common.QueuePersist;
import fr.CraftMyWebsite.CMWLink.Votes.Common.QueuedReward;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.plugin.Plugin;

public class RewardQueue {
    private CMWLPackage main;
    private QueuePersist persist = new QueuePersist(this);
    private Config config;
    private HashMap<String, QueuedReward> queue;
    private File qFile;
    private Plugin plugin;

    public RewardQueue(CMWLPackage main, Config config) {
        this.main = main;
        this.persist = new QueuePersist(this);
        this.config = config;
        this.queue = new HashMap();
        this.qFile = new File(String.valueOf(main.getMainFolder()) + File.separator + "Queue");
        if (!this.qFile.exists()) {
            this.qFile.mkdirs();
        }
        this.loadQueuedRewards();
    }

    public void addToQueue(QueuedReward qReward) {
        if (this.queue.containsKey(qReward.getUuid())) {
            ArrayList<String> cmds = new ArrayList<String>(this.queue.get(qReward.getUuid()).getCmds());
            cmds.addAll(qReward.getCmds());
            qReward.setCmds(cmds);
            this.queue.put(qReward.getUuid(), qReward);
        } else {
            this.queue.put(qReward.getUuid(), qReward);
        }
        this.qFile = new File(String.valueOf(this.main.getMainFolder()) + File.separator + "Queue" + File.separator + qReward.getUuid() + ".json");
        this.persist.save(this.queue.get(qReward.getUuid()), this.qFile);
    }

    private void loadQueuedRewards() {
        for (File fileEntry : new File(String.valueOf(this.main.getMainFolder()) + File.separator + "Queue").listFiles()) {
            QueuedReward reward = this.persist.load(QueuedReward.class, fileEntry);
            this.queue.put(fileEntry.getName().replace(".json", ""), reward);
        }
        this.main.log(Level.INFO, "Loaded Reward Queue, there is " + this.queue.size() + " reward waiting !");
    }

    @Generated
    public CMWLPackage getMain() {
        return this.main;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public HashMap<String, QueuedReward> getQueue() {
        return this.queue;
    }

    @Generated
    public Plugin getPlugin() {
        return this.plugin;
    }
}

