<?php

namespace CMW\Entity\Users;

use CMW\Controller\Users\UsersSessionsController;
use CMW\Manager\Package\AbstractEntity;
use CMW\Utils\Date;

class UserEntity extends AbstractEntity
{
    private int $userId;
    private string $userMail;
    private string $userPseudo;
    private string $userFirstName;
    private string $userLastName;
    private int $userState;
    private ?int $userTermsAccepted;
    private ?string $userTermsAcceptedAt;
    private string $userKey;
    private User2FaEntity $user2Fa;
    private string $userLastConnection;
    /** @var \CMW\Entity\Users\RoleEntity|\CMW\Entity\Users\RoleEntity[] $userRoles */
    private array $userRoles;
    private ?RoleEntity $userHighestRole;
    private string $userCreated;
    private string $userUpdated;
    private ?UserPictureEntity $userPicture;
    private ?string $loginMethode;

    /**
     * @param int $userId
     * @param string $userMail
     * @param string $userPseudo
     * @param string $userFirstName
     * @param string $userLastName
     * @param int $userState
     * @param ?int $userTermsAccepted
     * @param ?string $userTermsAcceptedAt
     * @param string $userKey
     * @param \CMW\Entity\Users\User2FaEntity $user2Fa
     * @param string $userLastConnection
     * @param \CMW\Entity\Users\RoleEntity[] $userRoles
     * @param ?\CMW\Entity\Users\RoleEntity $userHighestRole
     * @param string $userCreated
     * @param string $userUpdated
     * @param \CMW\Entity\Users\UserPictureEntity|null $userPicture
     * @param string|null $loginMethode
     */
    public function __construct(int $userId, string $userMail, string $userPseudo, string $userFirstName, string $userLastName, int $userState, ?int $userTermsAccepted, ?string $userTermsAcceptedAt, string $userKey, User2FaEntity $user2Fa, string $userLastConnection, array $userRoles, ?RoleEntity $userHighestRole, string $userCreated, string $userUpdated, ?UserPictureEntity $userPicture, null|string $loginMethode)
    {
        $this->userId = $userId;
        $this->userMail = $userMail;
        $this->userPseudo = $userPseudo;
        $this->userFirstName = $userFirstName;
        $this->userLastName = $userLastName;
        $this->userState = $userState;
        $this->userTermsAccepted = $userTermsAccepted;
        $this->userTermsAcceptedAt = $userTermsAcceptedAt;
        $this->userKey = $userKey;
        $this->user2Fa = $user2Fa;
        $this->userLastConnection = $userLastConnection;
        $this->userRoles = $userRoles;
        $this->userHighestRole = $userHighestRole;
        $this->userCreated = $userCreated;
        $this->userUpdated = $userUpdated;
        $this->userPicture = $userPicture;
        $this->loginMethode = $loginMethode;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->userId;
    }

    /**
     * @return string
     */
    public function getMail(): string
    {
        return $this->userMail;
    }

    /**
     * @return string
     */
    public function getPseudo(): string
    {
        return $this->userPseudo;
    }

    /**
     * @return string
     */
    public function getFirstName(): string
    {
        return $this->userFirstName;
    }

    /**
     * @return string
     */
    public function getLastName(): string
    {
        return $this->userLastName;
    }

    /**
     * @return int
     */
    public function getState(): int
    {
        return $this->userState;
    }

    /**
     * @return ?int
     */
    public function getTermsAccepted(): ?int
    {
        return $this->userTermsAccepted;
    }

    /**
     * @return ?string
     */
    public function getTermsAcceptedAtUnformatted(): ?string
    {
        return $this->userTermsAcceptedAt;
    }

    /**
     * @return ?string
     */
    public function getTermsAcceptedAt(): ?string
    {
        if ($this->userTermsAcceptedAt) {
            return Date::formatDate($this->userTermsAcceptedAt);
        }
        return null;
    }

    /**
     * @return string
     */
    public function getUserKey(): string
    {
        return $this->userKey;
    }

    /**
     * @return \CMW\Entity\Users\User2FaEntity
     */
    public function get2Fa(): User2FaEntity
    {
        return $this->user2Fa;
    }

    /**
     * @return string
     * @Desc date
     */
    public function getLastConnection(): string
    {
        return Date::formatDate($this->userLastConnection);
    }

    /**
     * @return string
     * @Desc date
     */
    public function getLastConnectionUnformatted(): string
    {
        return $this->userLastConnection;
    }

    /**
     * @return \CMW\Entity\Users\RoleEntity[]
     */
    public function getRoles(): array
    {
        return $this->userRoles;
    }

    /**
     * @return ?\CMW\Entity\Users\RoleEntity
     */
    public function getHighestRole(): ?RoleEntity
    {
        return $this->userHighestRole;
    }

    /**
     * @return string
     * @desc date
     */
    public function getCreated(): string
    {
        return Date::formatDate($this->userCreated);
    }

    /**
     * @return string
     * @desc date
     */
    public function getUpdated(): string
    {
        return Date::formatDate($this->userUpdated);
    }

    /**
     * @return \CMW\Entity\Users\UserPictureEntity | null
     */
    public function getUserPicture(): ?UserPictureEntity
    {
        return $this->userPicture;
    }

    /**
     * @return string
     */
    public function getLoginMethode(): string
    {
        return $this->loginMethode ?? 'native';
    }

    /**
     * @return bool
     */
    public function useNativeLoginMethode(): bool
    {
        return is_null($this->loginMethode);
    }

    /**
     * @return bool
     * @desc Return true if the current user is the page owner
     */
    public function isViewerIsCurrentUser(): bool
    {
        return UsersSessionsController::getInstance()->getCurrentUser()?->userId === $this->userId;
    }
}
