<?php

return [
    'home' => 'Accueil',
    'cgu' => 'CGU',
    'cgv' => 'CGV',
    'nolink' => 'Pas de lien ou de redirection',
    'general' => 'Général',
    'package' => 'Package',
    'packages' => 'Packages',
    'games' => 'Jeux',
    'themes' => 'Themes',
    'alt' => [
        'logo' => 'Logo CMW',
    ],
    'source_code' => 'Code source',
    'header' => [
        'notification' => 'Notifications',
        'cms_ver' => 'CMS : Version',
        'cms_update' => 'Une mise à jour du CMS est disponible !',
        'update_to' => 'Veuillez mettre à jour vers la version %version%',
        'package' => 'Package',
        'theme' => 'Thème',
        'all_is_fine' => 'Tout va bien',
        'is_up' => 'Votre site est entièrement à jour',
    ],
    'condition' => [
        'title' => 'Conditions générales',
        'cgv' => 'Conditions générales de vente (CGV)',
        'cgu' => "Conditions générales d'utilisation (CGU)",
        'activecgv' => 'Activer les CGV',
        'activecgu' => 'Activer les CGU',
        'content' => 'Contenu :',
        'updateby' => 'Mis à jour par %author%',
        'on' => 'le %date%',
    ],
    'terms' => [
        'title' => 'Terms et conditions',
        'requires_accept' => 'Les utilisateurs doivent l\'accepter à nouveau ?',
        'mandatory' => 'Ce terme est obligatoire (RGPD / CCPA / PIPEDA / LPRPDE / UK GDPR / APPI ...)',
        'use' => 'Actif',
        'requires_accept_explain' => 'Oblige les utilisateurs à revalider <b>%type%</b> à leur prochaine connexion. Recommandé pour les changements majeurs afin de rester conforme à la loi.',
        'last_published' => "Dernière mise à jour :",
        'last_editor' => 'Auteur :',
        'type' => [
            'TERMS_OF_SERVICE' => 'Condition d\'utilisation',
            'TERMS_OF_SALE' => 'Condition de ventes',
            'PRIVACY_POLICY' => 'Politique de confidentialité',
            'LEGAL_NOTICE' => 'Mentions légales',
            'COOKIE_POLICY' => 'Politique relative aux cookies',
            'ACCEPTABLE_USE' => 'Code de conduite',
            'LICENSE' => 'Propriété intellectuelle',
            'REFUND_POLICY' => 'Politique de remboursement',
        ],
        'toaster' => [
            'savedN' => 'Configuration enregistrée — %d élément(s) mis à jour.',
            'noChange' => 'Aucun changement.',
        ],
    ],
    'dashboard' => [
        'title' => 'Tableau de bord',
        'desc' => "Bienvenue sur votre panneau d'administration !",
        'total_member' => 'Membres totaux',
        'best_views' => 'Record de visites',
        'numbers_views' => 'Visites',
        'daily_visits' => 'Visites du jour',
        'monthly_visits' => 'Visites du mois',
        'total_visits' => 'Visites totales',
        'welcome' => 'Bienvenue',
        'site_info' => 'Informations du site',
        'name' => 'Nom : %name%',
        'description' => 'Description : %description%',
        'edit' => 'Modifier ces informations',
        'visits' => 'Visites',
        'registers' => 'Inscriptions',
        'days' => 'Jours',
        'weeks' => 'Semaines',
        'months' => 'Mois',
        'alpha' => 'Veuillez noter que CraftMyWebsite2 est actuellement en phase BETA et n\'est pas encore achevé. <br>Son utilisation en environnement de production est fortement déconseillée. Des fonctionnalités clés peuvent manquer ou ne pas fonctionner comme prévu. <br><b>Pendant cette phase, des réinstallations complètes du système pourront être nécessaires.</b> <br>Nous vous remercions de votre compréhension et de votre patience pendant que nous travaillons sur CraftMyWebsite.',
        'updateWarning' => '<strong>Attention :</strong> La version actuelle de votre CMS n\'est pas la dernière disponible.Il est fortement conseillé de <a class="link" href="updates/cms">mettre à jour</a> votre CMS pour bénéficier des derniers correctifs de sécurité ainsi que des nouvelles fonctionnalités ajoutées.',
    ],
    'menus' => [
        'title' => 'Menus',
        'desc' => 'Gérez les menus de votre site',
        'delete_title' => 'Supression de : %menu%',
        'delete_message' => 'Cette suppression est définitive',
        'send_to' => 'Renvoie vers : %url%',
        'add_sub_menu' => "Ajout d'un sous-menu dans %menu%",
        'add' => [
            'sub_menu' => "Ajout d'un sous-menu dans",
            'name' => 'Nom du menu',
            'name_hint' => 'Votes',
            'targetBlank' => 'Ouvrir la page dans un nouvel onglet',
            'choice' => 'Type de lien',
            'package' => 'Package',
            'package_select' => 'Sélection du package',
            'custom' => 'Personnalisé',
            'custom_hint' => 'https://store.monsite.fr',
            'allowedGroups' => 'Autorisez certains rôles à voir ce menu',
            'group_select' => 'Sélection des rôles',
            'toaster' => [
                'success' => 'Menu ajouté avec succès !',
            ],
        ],
        'edit' => [
            'name' => 'Édition du menu',
        ],
    ],
    "editor" => [
        "title" => "Configuration éditeur",
        "desc" => "Personnaliser l'éditeur de pages",
        "style" => "Style du syntax highlighter",
        "preview" => 'Vous pouvez prévisualiser le rendu des styles <a href="https://highlightjs.org/static/demo/" target="_blank">ici</a>',
    ],
    "config" => [
        "title" => "Réglages du site",
        "head" => "Réglages",
        "desc" => "Configurez votre site CMW !",
        "favicon" => "Modifiez le favicon",
        "favicon_tips" => 'CraftMyWebsite accepte uniquement les images <a href="https://www.icoconverter.com" target="_blank">.ico</a> pour des soucis de performances.',
        "alert_img" => "Faites CTRL + F5 pour afficher votre nouvelle icône",
        "alert_img_no_ico" => "Votre image doit être au format .ico",
        "dateFormat" => "Format des dates",
        "dateFormatTooltip" => "Vous pouvez personnaliser la façon dont vous affichez les dates",
        "custom" => "-- Personnalisez-moi --",
    ],
    'Lang' => [
        'title' => 'Langues',
        'desc' => 'Configurez les langues de votre site CMW !',
        'change' => 'Changez la langue du site',
    ],
    'website' => [
        'name' => 'Nom du site',
        'description' => 'Description du site',
    ],
    "minecraft" => [
        "ip" => "Addresse IP de votre serveur",
        "register" => "Autorisez uniquement les comptes Minecraft officiels à s'inscrire sur votre site",
    ],
    'database' => [
        'error' => 'Erreur de base de données : ',
    ],
    'toaster' => [
        'success' => 'Succès',
        'warning' => 'Attention',
        'error' => 'Erreur',
        'internalError' => 'Erreur interne',
        'config' => [
            'success' => 'Configuration modifiée avec succès !',
        ],
        'mail' => [
            'test' => "Mail envoyé à l'adresse %mail%",
        ],
        'theme' => [
            'regenerate' => 'Configuration du thème regénérée',
            'installed' => "%theme% viens d'être installé et activé.",
            'reset' => 'Configuration du thème réinitialisée',
            'updateBeforeInstall' => 'Veuillez mettre à jour le CMS avant d\'installer ce thème !',
            'updateBeforeUpdate' => 'Veuillez mettre à jour le CMS avant de mettre à jour vos thèmes !',
            'unableUpdate' => 'Impossible d\'installer : ',
            'unableDeleteFolder' => 'Impossible du supprimer le dossier : ',
            'delete' => [
                'success' => 'Theme %theme% supprimé avec succès',
                'error' => [
                    'not_found' => 'Theme %theme% introuvable',
                    'theme_is_default' => 'Impossible de supprimer le thème par défaut',
                    'delete_database' => 'Impossible de supprimer la configuration du thème',
                    'delete_files' => 'Impossible de supprimer les fichiers du thème',
                ],
            ],
            'editor' => [
                'title' => 'Editeur - DEV',
                'multipleMenu' => 'Attention le menu <b>%menukey%</b> est défini plusieurs fois !',
                'multipleMenuKey' => 'Attention la clé <b>%key%</b> est présente plusieurs fois dans le menu <b>%menukey%</b> !',
            ],
        ],
        'package' => [
            'updateBeforeInstall' => 'Veuillez mettre à jour le CMS avant d\'installer ce package !',
            'updateBeforeUpdate' => 'Veuillez mettre à jour le CMS avant de mettre à jours vos packages !',
        ],
        'db' => [
            'config' => [
                'success' => 'Configuration fonctionnelle',
                'error' => 'Configuration invalide',
                'alreadyInstalled' => 'Base de données déjà installée !',
            ],
            'missing_inputs' => 'Merci de remplir tous les champs !',
        ],
        'security' => [
            'healthReport' => [
                'copied' => 'Contenu copié !',
                'delete' => 'Health Reports supprimés',
            ],
        ],
    ],
    'datatables' => [
        'list' => [
            'processing' => 'Traitement en cours...',
            'search' => 'Rechercher&nbsp; ',
            'lenghtmenu' => 'Afficher _MENU_ &eacute;l&eacute;ments',
            'setlimit' => 'Afficher {select} &eacute;lement par page',
            'info' => "Affichage de l\'&eacute;lement _START_ &agrave; _END_ sur _TOTAL_ &eacute;l&eacute;ments",
            'info_vanilla' => 'Affichage des &eacute;lements {start} &agrave; {end} sur {rows} &eacute;l&eacute;ments',
            'info_empty' => "Affichage de l\'&eacute;lement 0 &agrave; 0 sur 0 &eacute;l&eacute;ments",
            'info_filtered' => '(filtr&eacute; de _MAX_ &eacute;l&eacute;ments au total)',
            'info_postfix' => '',
            'loadingrecords' => 'Chargement en cours...',
            'zerorecords' => 'Aucun &eacute;l&eacute;ment &agrave; afficher',
            'emptytable' => 'Aucune donnée disponible dans le tableau',
            'first' => 'Premier',
            'previous' => 'Pr&eacute;c&eacute;dent',
            'next' => 'Suivant',
            'last' => 'Dernier',
            'sort' => [
                'ascending' => ': activer pour trier la colonne par ordre croissant',
                'descending' => ': activer pour trier la colonne par ordre décroissant',
            ],
        ],
    ],
    "theme" => [
        "myThemes" => "Mes thèmes",
        "market" => "Market",
        "details" => "Détails",
        "install" => "Installer",
        "notVerified" => "Non verifié par CMW.",
        "active" => "Thème actif",
        "configure" => "Configurer",
        "reset" => "Réinitialiser %theme%",
        "leave" => "Quitter l'éditeur",
        "menu" => "MENU D'ÉDITION",
        "backMenu" => "Retour au menu",
        "reinstall" => "Réinstaller",
        "description" => "Description : ",
        "update" => "Mise à jour disponible !",
        "descriptionManualInstall" => "Ce thème est installé manuellement, il n'est pas enregistré auprès de CraftMyWebsite.<br>Utilisez ce thème en connaissance de cause.<br>Si vous développez ce thème pour le publier ensuite sur le Market de CraftMyWebsite ne tenez pas compte de ce message.",
        "descriptionIsSampler" => "Sampler est le thème par défaut fourni avec CraftMyWebsite.",
        "author" => "Auteur : ",
        "demo" => "Démo",
        "activate" => "Activer",
        "downloads" => "Téléchargements : ",
        "themeVersion" => "Version du thème : ",
        "localThemeVersion" => "Version du thème installé : ",
        "CMWVersion" => "Version CMW recommandée : ",
        "close" => "Fermer",
        "appearance" => "Apparence de ",
        "verification" => "Vérification",
        "verificationText" => "Attention, cela va remettre tous les paramètres par défaut de votre thème. Êtes-vous certain de vouloir poursuivre ?",
        "config" => [
            "title" => "Gestion",
            "description" => "Gérez les thèmes de votre site",
            "select" => "Choisissez votre thème",
            "list" => [
                "title" => "Liste des thèmes officiels",
                "info" => "Vous pouvez directement télécharger nos thèmes sur notre Market",
                "name" => "Nom",
                "version" => "Version",
                "cmw_version" => "Version CMW",
                "downloads" => "Nombre de téléchargements",
                "download" => "Télécharger",
            ],
            "regen_config" => "Regénérer la configuration du thème",
        ],
        'manage' => [
            'title' => 'Gérez votre thème <b>%Theme%</b>',
            'description' => 'Gérez votre thème pour le personnaliser à votre guise !',
            'theme_need_update' => 'Vous utilisez la version <b>%version%</b>, veuillez mettre à jour vers <b>%target%</b> !',
        ],
        'toasters' => [
            'update' => [
                'success' => 'Thème %theme% mis à jour avec succès',
            ],
            'delete' => [
                'title' => 'Supprimer %theme% ?',
                'confirm' => 'Voulez-vous vraiment supprimer %theme% ?',
                'config' => 'Cette suppression effacera également la configuration du thème.',
                'btn' => 'Supprimer',
            ],
        ],
    ],
    "Package" => [
        "title" => "Packages",
        "my_packages" => "Mes packages",
        "delete" => "Supprimer",
        "install" => "Installer",
        "update" => "Mettre à jour",
        "demo" => "Démo",
        "close" => "Fermer",
        "removeTitle" => "Voulez-vous supprimer %package% ?",
        "removeText" => "La suppression d'un package est définitive.<br>Voulez-vous continuer ?",
        "description" => "Description: ",
        "descriptionNotAvailable" => "Ce package est installé manuellement, il n'est pas enregistré auprès de CraftMyWebsite.<br>Utilisez ce package en connaissance de cause.<br>Si vous développez ce package pour le publier ensuite sur le Market de CraftMyWebsite, ne tenez pas compte de ce message.",
        "details" => "Détails",
        "author" => "Auteur : ",
        "downloads" => "Téléchargements : ",
        "version" => "Version du package : ",
        "localPackageVersion" => "Version du package installé : ",
        "versionCMW" => "Version CMW recommandée : ",
        "notVerified" => "Non verifié par CMW.",
        "updateAvailable" => "Mise à jour disponible !",
        "desc" => "Gérer vos packages",
        "myPackages" => "Mes packages",
        "market" => "Market",
        "toasters" => [
            "install" => [
                "success" => "Package %package% installé avec succès !",
            ],
            'delete' => [
                'success' => 'Package %package% supprimé avec succès',
                'error' => 'Impossible de supprimer le package %package%',
            ],
            'update' => [
                'success' => 'Package %package% mis à jour avec succès !',
            ],
        ],
        'versionDistant' => 'Dernière version en ligne',
    ],
    'mail' => [
        'config' => [
            'title' => 'Configuration mails',
            'description' => 'Gérez les mails de votre site',
            'enableSMTP' => 'Activation des mails SMTP',
            'senderMail' => "Adresse mail d'envoi",
            'replyMail' => 'Adresse mail de réponse',
            'serverSMTP' => 'Adresse du serveur SMTP',
            'userSMTP' => 'Utilisateur SMTP',
            'passwordSMTP' => 'Mot de passe SMTP',
            'portSMTP' => 'Port SMTP',
            'protocol' => "Protocole d'envoi",
            'footer' => 'Signature de vos mails',
            'formatting' => 'Mise en forme',
            'name' => "Nom d'affichage :",
            'placeholder' => 'Nom de votre site',
            'test' => [
                'btn' => 'Testez votre configuration',
                'title' => 'Essaye dès maintenant ta configuration',
                'warning' => 'Pensez à bien sauvegarder votre configuration avant de débuter le test !',
                'description' => 'Vous pouvez tester votre configuration en envoyant un mail à votre adresse e-mail.',
                'receiverMail' => 'Adresse e-mail du destinataire',
                'receiverMailPlaceholder' => "Entrez l'adresse mail",
            ],
        ],
        'test' => [
            'object' => '✅ Test d’envoi d’email CraftMyWebsite',
            'body' => '<p>Bonjour,</p><p>Ce message a été envoyé automatiquement pour vérifier le bon fonctionnement du système d’envoi d’emails de votre site.</p><p>Si vous avez bien reçu ce message, cela signifie que tout est configuré correctement.</p><p>Merci d’utiliser CraftMyWebsite ! 🚀</p>',
        ],
        'editor' => [
            'title' => 'Éditeur de mail (HTML)',
            'select' => 'Sélectionnez un template',
            'select_alert' => 'La selection d\'un template écrasera votre model actuel !',
            'apply_btn' => 'Appliquer',
            'modal_title' => 'Bon à savoir',
            'modal_text_1' => 'Cet éditeur vous permet de personnaliser l\'apparence de vos e-Mails, vous devez comprendre que ce model est envoyé à chaque fois qu\'un mail part peu importe le type de mail envoyé (shop, forum, newsletter, connexion, inscription...), gardez-bien cela a l\'esprit quand vous configurez votre template.',
            'modal_text_2' => 'Il est impératif d\'utiliser <code style="color: #2b2929; background: #efa1a1; border-radius: 5px; padding: 0 .2rem 0 .2rem">[MAIL_CONTENT]</code> dans votre template, c\'est ici que sera placé le message envoyé par le site',
            'modal_text_3' => 'Tips : Les police d\'écriture pris en charge par défaut par la plupart des boites mails sont :',
            'render' => 'Rendu en direct des mails',
            'render_example' => '<p>[EXEMPLE]</p> <p>Ceci est un exemple de contenu de vos mails envoyés.</p> <p>Le message sera inséré automatiquement ici.</p> <p>[EXEMPLE]</p>',
            'render_alert' => 'Le contenu du mail doit contenir [MAIL_CONTENT] !',
        ],
        'implementations' => [
            'basicSign' => 'Sans style - Avec signature',
            'emptyMail' => 'Sans style',
            'redMail' => 'Rouge avec carte centré',
        ],
    ],
    'downloads' => [
        'errors' => [
            'internalError' => 'Erreur interne avec la ressource %name% - %version%',
        ],
    ],
    "updates" => [
        "title" => "Mettez à jour votre site",
        "description" => "Mettez à jour votre site CraftMyWebsite",
        "pageTitle" => "Mises à jour du CMS",
        "updateButton" => "Mettre à jour",
        "warningUpdate" => "Attention ! Vous n'utilisez pas la dernière version du CMS, veuillez le mettre à jour dès maintenant.",
        "updateTo" => "Veuillez mettre à jour vers la version",
        "isUp" => "Votre CMS est à jour !",
        "availableFrom" => "Disponible depuis le :",
        "lastNote" => "Notes de version :",
        "previousVersion" => "Versions précedentes",
        "publishAt" => "Publié le",
        "errors" => [
            "download" => "Impossible de télécharger la dernière version du CMS.",
            "nullFileUpdate" => "Cette version n'a pas de fichier de mise à jour.",
            "prepareArchive" => "Impossible de préparer l'archive pour la mise à jour.",
            "deletedFiles" => "Impossible de supprimer les anciens fichiers.",
            "deleteFile" => "Impossible de supprimer le fichier %file%",
            "sqlUpdate" => "Impossible de mettre à jour la base de données.",
            'devVersion' => 'Vous utilisez une version de développement de CraftMyWebsite, impossible de mettre à jour.',
        ],
        'success' => 'Mise à jour de votre site réussie',
    ],
    'security' => [
        'title' => 'Sécurité',
        'description' => 'Gérez la sécurité de votre site',
        'no_captcha' => 'Pas de captcha',
        'free_key' => 'Obtenez vos clés ici gratuitement :',
        'captcha' => [
            'title' => 'Gestion du captcha',
            'type' => 'Type de captcha',
            'invalid' => 'Captcha invalide',
        ],
        'healthReport' => [
            'title' => 'Health Report',
            'subtitle' => 'Késako ?',
            'content' => "<p>Le health report permet à notre équipe de support de vous aider en envoyant un maximum
                    d'informations (non sensibles) à propos de votre site.</p>

                <p>
                    <b>Pensez à supprimer vos health reports une fois le support terminé !
                        Sinon vous exposez votre site à des failles.</b>
                </p>

                <p>
                    <i>Il est <b>impératif</b> d'envoyer vos Health Report uniquement à <b>l'équipe CraftMyWebsite</b> si on vous le demande.</i>
                </p>",
            'emplacement' => 'Emplacement du Health Report',
            'copy' => 'Copier le contenu',
        ],
    ],
    'maintenance' => [
        'title' => 'Maintenance',
        'description' => 'Gérez les maintenances de votre site',
        'main_label' => 'Mode maintenance',
        'settings' => [
            'info' => 'Informations',
            'noEnd' => 'Préciser une date de fin',
            'activated' => 'Activé',
            'deactivated' => 'Désactivé',
            'title' => 'Réglages',
            'targetDateTitle' => 'Se termine le',
            'useMyCode' => 'Utiliser mon code',
            'neRegister' => 'Désactiver les inscriptions',
            'maintenanceTitle' => [
                'label' => 'Titre',
                'placeholder' => 'Nous revenons très vite !',
            ],
            'maintenanceDescription' => [
                'label' => 'Description',
                'placeholder' => 'Nous faisons quelques modifications, nous revenons très vite !',
            ],
            'toaster' => [
                'enabled' => 'Maintenance activée',
                'disabled' => 'Maintenance désactivée',
                'error' => 'Impossible de mettre à jour la maintenance',
            ],
        ],
    ],
    'footer' => [
        'left' => '© 2014 - ' . date('Y') . ' CraftMyWebsite. Tous droits réservés.',
        'right' => "Merci d'utiliser <a target='_blank' href='https://craftmywebsite.fr/'>CraftMyWebsite</a>.",
        'used' => 'Vous utilisez la version ',
        'upgrade' => 'Veuillez mettre à jour vers la version',
    ],
    'btn' => [
        'save' => 'Sauvegarder',
        'delete' => 'Supprimer',
        'delete_forever' => 'Supprimer définitivement',
        'mass_delete' => 'Suppression de masse',
        'close' => 'Fermer',
        'send' => 'Envoyer',
        'download' => 'Télécharger',
        'add' => 'Ajouter',
        'edit' => 'Modifier',
        'action' => 'Action',
        'confirm' => 'Confirmer',
        'next' => 'Suivant',
        'try' => 'Tester',
        'continue' => 'Continuer',
        'generate' => 'Générer',
        'enable' => 'Activer',
        'enabled' => 'Activé',
        'disable' => 'Désactiver',
        'disabled' => 'Désactivée',
        'saving' => 'Sauvegarde ...',
        'reset' => 'Réinitialiser',
    ],
    'months' => [
        'list' => '["Janvier","Février","Mars","Avril","Mai","Juin","Juillet","Août","Septembre","Octobre","Novembre","Décembre"]',
        1 => 'Janvier',
        2 => 'Février',
        3 => 'Mars',
        4 => 'Avril',
        5 => 'Mai',
        6 => 'Juin',
        7 => 'Juillet',
        8 => 'Août',
        9 => 'Septembre',
        10 => 'Octobre',
        11 => 'Novembre',
        12 => 'Décembre',
    ],
    'week' => 'Semaine ',
    'errors' => [
        'requests' => [
            'required' => 'Champ %key% manquant',
            'empty' => 'Champ %key% vide',
            'slug' => 'Slug %key% invalide',
            'minLength' => 'Le champ %key% doit contenir plus de %min% caractères',
            'maxLength' => 'Le champ %key% doit contenir moins de %max% caractères',
            'betweenLength' => 'Le champ %key% doit contenir entre %min% et %max% caractères',
            'dateTime' => 'Le champ %key% doit être une date valide (%format%)',
            'getValue' => 'Valeur introuvable %key%',
            'type' => 'Type invalide pour %key%',
        ],
        'editConfiguration' => 'Impossible de modifier la configuration %config%',
        'upload' => [
            'image' => "Erreur lors de l'envoie de l'image.",
        ],
    ],
    "permissions" => [
        "dashboard" => "Accès au panel d'administration",
        "notification" => [
            "notification" => "Voir les notifications",
            "read" => "Marquer comme lue",
            "settings" => "Paramètres",
        ],
        "settings" => [
            "title" => "Paramètres",
            "website" => "Réglages du site",
            "maintenance" => "Maintenance",
            "maintenance_bypass" => "Outrepasser le blocage",
            "mails" => "SMTP et mails",
            "conditions" => "Conditions générales",
            "security" => "Sécurité",
            "security_healthReport" => "Générer un rapport",
        ],
        'menu' => 'Menus',
        'update' => 'Mises à jour du CORE',
        'themes' => [
            'title' => 'Thèmes',
            'edit' => "Éditer l'actif",
            'manage' => 'Gérer les installations',
            'market' => 'Installer depuis le market',
        ],
        'packages' => [
            'title' => 'Packages',
            'manage' => 'Gérer les installations',
            'market' => 'Installer depuis le market',
        ],
    ],
    'menu' => [
        'setting' => [
            'main' => 'Paramètres',
            'settings' => 'Réglages du site',
            'maintenance' => 'Mode maintenance',
            'mail' => 'SMTP et mails',
            'cg' => 'Termes et Conditions',
            'security' => 'Sécurité',
        ],
        'update' => 'Mises à jour',
        'updateMe' => 'Mises à jour <i style="color:#da3434;" class="ml-1 fa-solid fa-circle-exclamation"></i>',
        'themes' => [
            'main' => 'Thèmes',
            'edit' => 'Modifier ',
            'installed' => 'Thèmes installés',
            'market' => 'Parcourir le Market',
            'toasters' => [
                'update' => [
                    'success' => 'Thème %theme% mis à jour avec succès',
                ],
            ],
        ],
        'package' => [
            'main' => 'Packages',
            'installed' => 'Packages installés',
            'market' => 'Parcourir le Market',
        ],
        'user' => [
            'main' => 'Utilisateurs',
            'settings' => 'Paramètres',
            'manage' => 'Gestion',
            'roles' => 'Rôles',
        ],
    ],
    'imageManager' => [
        'converter' => [
            'saving' => 'Erreur lors de la sauvegarde de l\'image.',
            'target' => 'Format cible invalide. Original conservé !',
            'conversion' => 'Format de conversion non supporté, Original conservé !',
            'converting' => 'Erreur lors de la conversion de l\'image. Original conservé !',
        ],
        'error' => [
            'fileDefinition' => 'Cette extension n\'est pas prise en charge !',
            'folderDontExist' => 'Dossier cible introuvable',
            'emptyFile' => 'Aucune image envoyé !',
            'tooLarge' => 'Image trop volumineuse !',
            'notAllowed' => 'Type de document non autorisé !',
            'move' => 'Impossible de déplacer l\'image.',
            'download' => 'Impossible télécharger l\'image.',
            'createFolder' => 'Impossible de créer le dossier cible, problème de permission sur Public/Uploads',
        ],
    ],
    'imageDropper' => [
        'fileDrop' => 'Glissez & Déposez vos images ici',
        'fileSize' => 'max autorisé !',
        'fileFormat' => 'Format non autorisé.',
    ],
    'themeNotFoundException' => [
        'title' => 'Erreur - Thème introuvable',
        'message1' => 'ne peut pas être votre thème actif, car nous ne le trouvons pas !',
        'message2' => 'Vérifiez que le thème est installé correctement ou que son nom est correct !',
        'path' => 'Chemin d\'accès : ',
        'use_sampler' => 'Voulez-vous activer le thème <b>Sampler</b> ?',
        'button' => 'Activer Sampler',
        'user' => [
            'title' => 'Problème de configuration !',
            'message1' => 'Merci de contacter l\'administrateur du site.',
            'error' => '<b>Erreur :</b> Nom de thème invalide !',
        ],
    ],

];
